---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-グローバル404ページ (Global Not Found)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/builtin/global-not-found.tsx` L1-16 - コンポーネント全体
- E-02: `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` L1-45 - HTTPAccessErrorFallback
- E-03: `packages/next/src/client/components/styles/access-error-styles.ts` L1-34 - スタイル定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L5 - 画面情報定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L13-14 - 関連機能情報
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` L33 - App Router遷移図

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルートレベルで一致するページがない場合に表示される | E-04, E-06 | ○ |
| C-02 | html/bodyタグを含む完全なページ構造を持つ | E-01 | ○ |
| C-03 | HTTPAccessErrorFallbackにstatus=404を渡す | E-01 | ○ |
| C-04 | message="This page could not be found."を表示 | E-01 | ○ |
| C-05 | h1にステータスコード、h2にメッセージを表示 | E-02 | ○ |
| C-06 | titleタグに「404: This page could not be found.」を設定 | E-02 | ○ |
| C-07 | ダークモード対応CSSが適用される | E-02 | ○ |
| C-08 | App Routerで使用される | E-04 | ○ |
| C-09 | エラーハンドリングが主機能 | E-05 | ○ |
| C-10 | プロパティを受け取らない | E-01 | ○ |
| C-11 | Flexbox中央配置レイアウト | E-03 | ○ |
| C-12 | セグメントレベルのNot Found(No.5)とは異なりhtml/body含む | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalNotFoundとNotFound(No.5)の違いが正確に記述されているか確認
- [ ] HTTPAccessErrorFallbackの表示仕様が実装と一致するか確認
